	name	labl
	page	55,132
	title	'LABEL --- display or change volume label'
;
; LABEL --- display or change volume label
;
; Copyright (c) 1984 by Ray Duncan
; May be freely reproduced and modified
; for non-commercial use.

cr	equ	0dh		;ASCII carriage return
lf	equ	0ah		;ASCII line feed
eom	equ	'$'             ;end of message flag

				;Program Segment Prefix:
command equ	80h		;command line buffer
default_fcb equ 05ch		;default file control block

rd_only equ	01h		;file attributes
hidden	equ	02h
system	equ	04h
volume	equ	08h
subdir	equ	10h
archive equ	20h


cseg	segment para public 'CODE'

	assume	cs:cseg,ds:data,es:data,ss:stack

labl	proc	far		;entry point from PC-DOS

	push	ds		;save DS:0000 for final
	xor	ax,ax		;return to PC-DOS
	push	ax
	mov	ah,48		;make sure this is DOS
	int	21h		;version 2.0 or greater
	cmp	al,2
	jae	labl1		;version is ok,jump
	mov	ax,data
	mov	ds,ax
	mov	dx,offset msg6	;version too low, print error
	mov	ah,9		;message and exit
	int	21h
	ret
labl1:	mov	ax,data 	;make our data segment addressable
	mov	es,ax		;via the ES register
	call	vol_name	;get name for new volume label
				;if any was given by user
	mov	ax,es		;now set DS=ES for remainder
	mov	ds,ax		;of the program.
	call	show_label	;display the current volume label
				;on the selected diskette. subroutine
				;returns AX=0 if no label on
				;disk, AX=-1 if label exists.
				;was new label supplied by user?
	cmp	byte ptr fcb+1,' '
	jne	labl2		;yes,change or add volume label
	ret			;no, display only, exit to PC-DOS

labl2:				;new name supplied by user.
	or	ax,ax		;was previous label present?
				;(flag in AX from SHOW_LABEL)
	jz	labl3		;no,jump
	mov	cx,11		;yes,change it
	mov	di,offset buffer+24
	mov	si,offset fcb+1 ;set up new name starting at
	rep movsb		; 6 bytes after old name
	mov	dx,offset buffer
	mov	ah,23		;request alteration of volume name
	int	21h		;by PC-DOS function 23=RENAME
	jmp	labl4		;go check if function was successful,
				;if it was display new volume name.

labl3:				;come here to add new label, if
				;diskette previously had no label.
	mov	dx,offset xfcb	;DX=addr of extended fcb
				;containing "volume" attribute byte.
	mov	ah,22		;Use PC-DOS function 22 to create
	int	21h		;a new directory entry.
labl4:	cmp	al,0ffh 	;was function successful?
	jne	labl5		;yes,jump to display new name.
	mov	dx,offset msg2	;no,print error message
	mov	ah,9		;and exit
	int	21h
	ret

labl5:				;label successfully created.
	mov	dx,offset msg3	;print first part of message.
	mov	ah,9
	int	21h
	mov	bx,offset fcb+1 ;print actual volume name
	call	print_vol	;in upper case.
	ret			;exit to PC-DOS.
labl	endp


show_label proc near		;Display the label for the
				;disk in the selected drive and
				;return AX=-1, or display message
				;and return AX=0 if no label exists.
	mov	dx,offset buffer
	mov	ah,26		;set disk transfer address
	int	21h		;for use in directory search
	mov	dx,offset sfcb	;now look for the first directory
				;entry with "volume" attribute,
	mov	ah,17		;using PC-DOS function 17
	int	21h		;"search for first matching filename"
	cmp	al,0ffh 	;any volume label found?
	je	show_label2	;no,jump
	mov	dx,offset msg4	;yes print message and
	mov	ah,9		;volume name
	int	21h
	mov	bx,offset buffer+8
	call	print_vol
	mov	ax,-1		;return AX=-1, label exists
	ret
show_label2:			;disk was not labeled,
	mov	dx,offset msg5	;so print message and
	mov	ah,9		;return AX=0 as signal that
	int	21h		;there is no previous label
	xor	ax,ax
	ret
show_label endp


print_vol proc	near		;print the volume name
				;whose offset is in BX on
				;the standard output device.
				;Regs AX, BX, DX destroyed.
	mov	cx,11		;name is max of 11 characters
pvol2:
	mov	dl,[bx] 	;get next char from string
     ;	cmp	dl,' '            ;prevented display of any imbedded
     ;	je	pvol2		  ;blanks actually in vol label  ???
	cmp	dl,'a'          ;if it is an lower-case alpha
	jb	pvol3		;character,fold to upper case
	cmp	dl,'z'
	ja	pvol3
	xor	dl,20h
pvol3:
	mov	ah,2		;function 2=output char.
	int	21h		;request output by PC-DOS
pvol4:	inc	bx		;advance to next string position
	loop	pvol2		;until 11 chars. processed.
pvol9:				;done with string output,
	mov	dx,offset msg1	;send final carriage return
	mov	ah,9		;and line feed,
	int	21h
	ret			;then return to caller
print_vol endp

vol_name proc	near		;Transfer the new volume name
				;from the Program Segment Prefix
				;into the local File Control Block

				;let DS:SI=command tail address
	mov	si,offset command
	lodsb			;check string length byte,
	or	al,al		;any name present?
	jz	vol_name4	;no,go get drive
vol_name1:			;scan for start of name
	lodsb			;get next char
	cmp	al,cr		;if carriage return,name is missing
	je	vol_name4	;so jump to get drive
	cmp	al,' '          ;if blank, keep looking
	je	vol_name1
				;now found none-blank char
				;let ES:DI = addr of name field
	mov	di,offset fcb+1 ;in local file control block
	mov	cx,11		;CX will be counter, 11 chars max.
				;did DOS's parser find legal drive?
	mov	ah,ds:default_fcb
	or	ah,ah
	jz	vol_name2	;no,jump.
	lodsb			;yes,then next char ought to
	cmp	al,':'          ;be a colon.
	jne	vol_name4	;not colon, some kind of error.
	lodsb			;fetch next character after colon.
	cmp	al,' '          ;make sure name is also there.
	jna	vol_name4	;no name,jump to get drive.
vol_name2:			;now we transfer bytes from
				;command tail into the fcb
				;for the new volume name.
	stosb
	lodsb			;check next char from input.
	cmp	al,' '          ;if xxxxx or any control char [xxx was blank]
	jb	vol_name4	;found end of name.	      [jb was jna]
			      ;[changed to permit imbedded blanks in new label
			      ;rather than truncating label at blank]
	loop	vol_name2	;otherwise, keep looking until
				;11 characters have been processed.
vol_name4:
	mov	al,ds:default_fcb
	or	al,al		;was disk drive specified?
	jnz	vol_name5	;yes,use it.
	mov	ah,25		;no, get identity of default drive.
	int	21h
	inc	al
vol_name5:			;put drive into file control blocks
	mov	es:fcb,al	;for search and new volume name.
	mov	es:sfcb+7,al
	add	al,'a'-1        ;also form ASCII letter for
	mov	es:msg2a,al	;drive, and put into
	mov	es:msg3a,al	;output messages.
	mov	es:msg4a,al
	mov	es:msg5a,al
	ret
vol_name endp

cseg	ends


				;data segment for
				;miscellaneous messages,
				;constants, and variables
data	segment para public 'DATA'
				;extended file control block
xfcb	db	0ffh		;flag for special fcb
	db	5 dup (0)	;reserved
	db	volume		;volume label attribute byte
				;remainder is "normal" fcb
fcb	db	0		;drive (set by VOL_NAME)
	db	11 dup (' ')    ;blank name field
	db	25 dup (0)

sfcb	db	0ffh		;extended file control block used
	db	5 dup (0)	;to search for current label
	db	volume
	db	0		;drive (set by VOL_NAME)
	db	11 dup ('?')    ;wildcard name
	db	25 dup (0)

buffer	db	128 dup (?)	;buffer for disk directory search

msg1	db	cr,lf,eom

msg2	db	cr,lf
	db	'Unable to write new label on disk '
msg2a	db	'x: ',cr,lf,eom

msg3	db	cr,lf
	db	'Label of disk in drive '
msg3a	db	'x: has been changed to ',eom

msg4	db	cr,lf,'Label of disk in drive '
msg4a	db	'x: is ',eom

msg5	db	cr,lf,'Disk in drive '
msg5a	db	'x: has no label.',cr,lf,eom

msg6	db	cr,lf
	db	'LABEL program requires DOS '
	db	'version 2.0 or greater.'
	db	cr,lf,eom

data	ends


stack	segment para stack 'STACK'
	db	64 dup (?)
stack	ends

	end	labl
